<?php
//	http://localhost/psp/staff/top_menu/1/1/平野
//	http://localhost/psp/staff/test
//  http://s.piearson.shop/psp/staff/top_menu/1/1/平野

App::uses('AppController', 'Controller');

class StaffController extends AppController {
	public $name = 'Staff';

	public $uses = array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
						'CheckDT1', 'CartDT7', 'CartORD', 'Config', 'TopMenu',
						'CheckDT1Old', 'CartDT7Old', 'CartORDOld');

	public $layout = 'staff';
	public $helpers = array('Common', 'Html');
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public $_store_id = 1;
	public $_store_name = "カラオケX";
	public $_staff_id = 1;
	public $_staff_name = "平野";
	
	public $_check_id = "";
	public $_room_no = "0";
	public $_order_no = 0;
	public $_checkin_time=NULL;
	public $_type = "";

	public $_kind = "";
	public $_error_msg = "";
	public $_staff_call_flag = 0;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "http://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

/********** MOD 2023/06/18 ******************************************************/
		$this->_server_name =  substr($_SERVER['SERVER_NAME'], 0, strpos($_SERVER['SERVER_NAME'], ".") );
		$this->_store_id = preg_replace('/[^0-9]/', '', $this->_server_name);
/********** MOD 2023/06/18 ******************************************************/

		if($this->_server_name == "s.")
			$this->_server_name = "s";

		$this->set('_store_id', $this->_store_id);
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "Staff画面".$this->_server_name2;
		$this->set('main_title', $main_title);

	}

	public function index($store_id=1, $staff_id=1, $staff_name="平野"){
		$this->redirect(array('controller' => 'staff', 'action' => 'top_menu' , $store_id,$staff_id,$staff_name));
	}



	public function top_menu($store_id=1, $staff_id=1, $staff_name=""){
		$this->Common->ResetModelID('CheckDT1');
		$this->_store_id = $store_id;
		$this->_staff_id = $staff_id;
				
		if($staff_name)
			$this->_staff_name = $staff_name;
		else
			$this->_staff_name = $this->request->data['staff_name'];
		
		$error_msg = "";
		$msg1 = $this->Store->field('msg1', array('id'=>3));
//debug($_SERVER['HTTP_REFERER']);	//'http://localhost/psp/config/store_edit/3'  //
//debug($this->_staff_name);
		if($msg1 != $this->_staff_name){
			$error_msg .= "QRコードIDエラーです。<br />QRコードID: ".$staff_name."<br />";
		}
		$this->set('error_msg', $error_msg);
		$this->GetStore();
		$this->SetPublicData();
		$this->MakeHidden();
	}
	


	public function undeliver(){
		$this->SetPublicData();
		$store = $this->GetStore();
//debug($this->data);

		if($this->data['kind']=="update"){
			for($i=0; $i<$this->data['count']; $i++){
//debug($this->data);
				if(isset($this->data['undeliver'][$i])){
					if($this->data['undeliver'][$i] > 0){
						//更新
						$save_array = array('id' => $this->data['id'][$i], 'deliver_send'=>1, 'deliver_time'=>date("Y-m-d H:i:s"));
//debug($save_array);
//exit();
						$ret = $this->CartORD->save($save_array);
					}
				
				}
			}
		}

		$cart = $this->GetCartData("order_history2");
		$this->set('cart', $cart);
//debug($cart);
		$this->MakeHidden();
	}

	public function checkin(){
		if(isset($this->request->data['db_cleaning'])){
			$this->db_cleaning();
		}
	
		$this->SetPublicData();
		$data = array();
		$data['kind'] = "step1";
		if($this->request->data){
//debug($this->request->data);
			$data = $this->request->data;
//debug($data);
			if(isset($data['kind'])){
				if($data['kind'] == "step2"){
					$data['kind'] = "step3";
					$data['check_id'] = $this->_check_id = "s".dechex(strtotime('now').sprintf('%02d', $data['room_no']));
					$this->_room_no = $data['room_no'];

					if(isset($data['checkin1'])){
						if($data['checkin1'] > 0)
							$data['checkin_mode']=1;
					}elseif(isset($data['checkin2'])){
						if($data['checkin2'] > 0)
							$data['checkin_mode']=2;
					}
				
				}elseif($data['kind'] == "step4"){
					$up_date = date("Y-m-d H:i:s");

					$closetime = $this->Common->OpenCloseTime($this, "close");
//debug($closetime);
					$dt = strtotime($closetime);
					$dt = strtotime("+1 day", $dt);
//debug("close=".date("Y-m-d H:i:s", $dt));

					$dt = $dt - strtotime('now');
//debug("**entry_close_time = ".($dt/60));

					$entry_close_time = (int)($dt/60);
//debug("entry_close_time = ".$entry_close_time);
//debug($entry_close_time/60);
//exit();

					$leave_remain_time = (int)$data['leave_remain_time1'] *60 + (int)$data['leave_remain_time2'] *10 + (int)$data['leave_remain_time3'];
					$drinkfree_time = (int)$data['drinkfree_time1'] *60 + (int)$data['drinkfree_time2'] *10 + (int)$data['drinkfree_time3'];
//debug($data);

					if($data['checkin_mode'] == 2){//継続利用
						$conditions = array('room_no' => $data['room_no']);	//, 'check_id' => $data['check_id']
						$orders = array('id' => 'DESC');
						$data2 = $this->CheckDT1->find('first', array('conditions' => $conditions, 'order'=>$orders));
//debug($data2);
						if(($data2['CheckDT1']['check_id']== null) or !$data2['CheckDT1']['check_id']){
							$data2['CheckDT1']['check_id'] = $data['check_id'];
						}
						if(isset($data2['CheckDT1']['id'])){
							$save_array = $data2['CheckDT1'];
							$save_array['leave_remain_time'] = $leave_remain_time;		//退出残り時間（分単位）
							$save_array['entry_close_time'] = $entry_close_time;	//入室時から閉店までの時間（分単位）
							$save_array['people'] = (int)$data['people'];		//入数
							$save_array['unit_price_kind'] = (int)$data['unit_price_kind'];		//単価
							$save_array['drink_free_kind'] =  (int)$data['drink_free_kind'];		//飲み放題種類
							$save_array['drink_free_time'] = $drinkfree_time;	//飲み放題残り時間
							$save_array['up_date'] = $up_date;
							
							$data['check_id'] = $data2['CheckDT1']['check_id'];
						}else{
							$this->_error_msg = "該当データなし";
							debug($this->_error_msg);
							$data['kind'] = "step1";
						}
//debug($data);
//exit();
					}elseif($data['checkin_mode'] == 1){	//新規利用
						$this->Common->MoveDT1Old($data['room_no'], $data['check_id']);
					
						$save_array = array (
							'check_id' => $data['check_id'],	//$this->Common->GetCheckID($room_no),
							'room_no' => $data['room_no'],
							'over_flag' => 2,				//2 or 3 超過0分から,
							'leave_remain_time'=> $leave_remain_time,		//退出残り時間（分単位）
							'entry_close_time' => $entry_close_time,	//入室時から閉店までの時間（分単位）
							'people' => (int)$data['people'],				//入数
							'unit_price_kind' => (int)$data['unit_price_kind'],				//単価
							'drink_free_kind' => (int)$data['drink_free_kind'],			//飲み放題種類
							'drink_free_time' => $drinkfree_time,	//飲み放題残り時間
							'up_date' => $up_date
						);
						$save_array['id'] = NULL;

					}
//debug($save_array);
//exit();
					$this->CheckDT1->save($save_array);
					$data['kind'] = "step5";

				}else{
					$data['kind'] = "step1";
				}
			}
			$this->_store_id = $data['store_id'];
		}
		$this->SetPublicData();
		if($data['kind'] == "step1"){
			$room_no_max = $this->Common->GetRoomNoMax();
			for($n = 1; $n <= $room_no_max; $n++){
				$fields = array('id');
				$orders = array('id' => 'desc');
				$conditions = array('room_no' => $n);
				$m = $this->CheckDT1->find('first', array('fields'=>$fields, 'conditions'=>$conditions, 'order'=>$orders ));
				if(isset($m['CheckDT1']['id']))
					$check[$n] = $m['CheckDT1']['id'];
				else
					$check[$n] = 0;
			}
			$this->set('check', $check);
		}
//debug($check);
		if($data['kind'] == "step3"){
			$data['leave_remain_time1']=2;
			$data['leave_remain_time2']=0;
			$data['leave_remain_time3']=0;

			$data['drinkfree_time1']=1;
			$data['drinkfree_time2']=0;
			$data['drinkfree_time3']=0;
			$data['drink_free_kind']=1;
		}
//debug($data);
//exit();
		$this->SetPublicData();
		$this->set('data', $data);
		$this->MakeHidden();
	}


	public function room_status(){
		$this->SetPublicData();
		$store = $this->GetStore();
		
		if($this->request->data){
//debug($this->request->data);
			if(isset($this->request->data['kind'])){
				$data = $this->request->data;
				if($this->request->data['kind']=="finished"){
//debug($data);
					$conditions = array('id' => $data['id']);	
					$check=$this->CheckDT1->find('first', array('conditions'=>$conditions));
					$check2=$check['CheckDT1'];
					$check2['id']=NULL;
//debug($check);
//debug($check2);
//exit();
					$this->CheckDT1Old->save($check2);
					$this->Common->MoveDT1Old($check2['room_no'], $check2['check_id'], 1);
					//$this->CheckDT1->delete($data['id']);
					$check3[0]['CartORD'] = $check2;
//debug($check3);
//exit();
					$this->WriteORD("T", $check3, 0);

				}elseif($this->request->data['kind']=="link"){

//exit();
//					$this->redirect(['controller' => 'order', 'action' => 'order_login', 
//						$data['store_id'], $data['room_no'], $data['check_id'], array('target' => '_blank')]);
				}
			}
		}
		
		$room_no_max = $this->Common->GetRoomNoMax();
		for($n = 1; $n <= $room_no_max; $n++){
			$fields = array('id');
			$orders = array('id' => 'desc');		//'desc'
			$conditions = array('room_no' => $n);		//, 'check_id' => ''	'fields'=>$fields, 	, 'group'=>$group
			//$m = $this->CheckDT1->find('first', array('fields'=>$fields, 'conditions'=>$conditions, 'order'=>$orders ));
			$m = $this->CheckDT1->find('first', array('conditions'=>$conditions, 'order'=>$orders ));
			if(empty($m))
				$check[$n]['CheckDT1']['room_no'] = $n;
			else
				$check[$n] = $m;
		}
		$this->set('check', $check);
//debug($check);
		$this->MakeHidden();
	
	}




	public function staff_call(){
		$this->SetPublicData();
		$this->GetStore();

		if($this->request->data){
			$data = $this->request->data;
			if($data['kind']=="update"){
				for($i=0; $i<$data['count']; $i++){
//debug($data);
					if(isset($data['check_ord'][$i])){
						if($data['check_ord'][$i] == 1){
							//更新
							$save_array = array('id' => $data['id'][$i], 'deliver_send'=>1, 'deliver_time'=>date("Y-m-d H:i:s"), 's_flag'=>0);
//debug($save_array);
//exit();
							$ret = $this->CartORD->save($save_array);
							
							$id = $this->CheckDT1->field('id', array('check_id'=>$data['check_id'][$i]), 'id DESC');
							$save_array = array('id' => $id, 'staff_call'=>0, 'staff_call_time'=>date("Y-m-d H:i:s"));
							$ret = $this->CheckDT1->save($save_array);
						}
					}
				}
			}
		}
		$conditions = array('order_no >'=>9970, 'deliver_send'=>0);
//debug($conditions);
		$order = array('room_no'=>'ASC', 'order_no'=>'ASC');	//ASC | DESC
		$ord = $this->CartORD->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('ord', $ord);

		//$this->CheckStaffCall();
		$this->MakeHidden();
	}


	public function enter_room_link(){
		$this->SetPublicData();
		$store = $this->GetStore();
		
		if($this->request->data){
//debug($this->request->data);
			if(isset($this->request->data['kind'])){
				$data = $this->request->data;
				if($this->request->data['kind']=="finished"){
//debug($data);
					$conditions = array('id' => $data['id']);	
					$check=$this->CheckDT1->find('first', array('conditions'=>$conditions));
					$check2=$check['CheckDT1'];
					$check2['id']=NULL;
//debug($check);
//debug($check2);
//exit();
					$this->CheckDT1Old->save($check2);
					$this->Common->MoveDT1Old($check2['room_no'], $check2['check_id'], 1);
					//$this->CheckDT1->delete($data['id']);
					$check3[0]['CartORD'] = $check2;
//debug($check3);
//exit();
					$this->WriteORD("T", $check3, 0);

				}elseif($this->request->data['kind']=="link"){

//exit();
//					$this->redirect(['controller' => 'order', 'action' => 'order_login', 
//						$data['store_id'], $data['room_no'], $data['check_id'], array('target' => '_blank')]);
				}
			}
		}
		
		$room_no_max = $this->Common->GetRoomNoMax();
		for($n = 1; $n <= $room_no_max; $n++){
			$fields = array('id');
			$orders = array('id' => 'desc');		//'desc'
			$conditions = array('room_no' => $n);		//, 'check_id' => ''	'fields'=>$fields, 	, 'group'=>$group
			//$m = $this->CheckDT1->find('first', array('fields'=>$fields, 'conditions'=>$conditions, 'order'=>$orders ));
			$m = $this->CheckDT1->find('first', array('conditions'=>$conditions, 'order'=>$orders ));
			if(empty($m))
				$check[$n]['CheckDT1']['room_no'] = $n;
			else
				$check[$n] = $m;
		}
		$this->set('check', $check);
//debug($check);
		$this->MakeHidden();
	}



	private function GetStore(){
		$store = $this->Store->find('first', array('conditions' => array('Store.id' => $this->_store_id)));
		//if (! $this->data){ throw new NotFoundException(); }
		if(!$store){ echo "エラーGetStore"; debug("Error!!!"); }
//debug($store);
		$this->_store_id = $store['Store']['id'];
		$this->set('_store_id', $this->_store_id);

		$this->_store_name = $store['Store']['store_name'];
		$this->set('_store_name', $this->_store_name);

		$this->set('store', $store['Store']);
	}

	private function GetCartData($mode = ""){
//`id`,`check_id`,`room_no`,`total`,`room_charge`,`products`,`order_no`,`qty`,`price`,`up_date`,
		if($mode == "" or $mode == "all")
			$conditions = array('room_no' => $this->_room_no, 'check_id LIKE'=>$this->_check_id, 'order_send_flag'=>0);
		elseif($mode == "cart")
			$conditions = array('room_no' => $this->_room_no, 'check_id LIKE'=>$this->_check_id, 'order_send_flag'=>0);
		elseif($mode == "order_history1")
			$conditions = array('room_no' => $this->_room_no, 'check_id LIKE'=>$this->_check_id, 'order_send_flag'=>0);

		elseif($mode == "order_history2")
			$conditions = array('order_send_flag >'=>0, 'deliver_send'=>0);

		elseif($mode == "order_send")
			$conditions = array('room_no' => $this->_room_no, 'check_id LIKE'=>$this->_check_id, 'order_send_flag'=>0);
		elseif($mode == "check")
			$conditions = array('room_no' => $this->_room_no, 'check_id LIKE'=>$this->_check_id, 'order_send_flag >'=>0);
		elseif($mode == "order_logout")
			$conditions = array('check_id LIKE'=>$this->_check_id);
		else
			$conditions = array('check_id LIKE'=>$this->_check_id);
		
//debug($conditions);
		$order = array('id' => 'ASC');	//ASC | DESC
		$cart = $this->CartORD->find('all', array('conditions' => $conditions, 'order' => $order));
		
//debug($cart);
		if(count($cart) == 0){
			$this->set('cart', $cart);
			return array();
		}
		$this->set('cart', $cart);
		return $cart;
	}

	public function GetCartDT7Data(){
		$conditions = array('room_no' => $this->_room_no, 'check_id' => $this->_check_id);
		$order = array('id' => 'DESC');	//ASC | DESC
		$cart_dt7 = $this->CartDT7->find('first', array('conditions' => $conditions, 'order' => $order));
		return $cart_dt7;
	}






	private function SetPublicData(){
//debug($this->data);
//debug($this->_room_no);
//exit();
		if(isset($this->data['store_id']))
			$this->_store_id = $this->data['store_id'];
		if($this->_store_id == 0){
			$error_msg = "エラー　店舗番号が0です。";
			//$this->redirect(array('controller' => 'staff', 'action' => 'top_menu', $this->_store_id."/".$this->_room_no."/".$error_msg));
		}
		$this->set('_store_id', $this->_store_id);

		if(isset($this->data['store_name']))
			$this->_store_name = $this->data['store_name'];
		if($this->_store_name == ""){
			$error_msg = "エラー　店舗名がないです。";
			//$this->redirect(array('controller' => 'staff', 'action' => 'top_menu', $this->_store_id."/".$this->_room_no."/".$error_msg));
		}
		$this->set('_store_name', $this->_store_name);

		if(isset($this->data['room_no']))
			$this->_room_no = $this->data['room_no'];
		if($this->_room_no == 0){
			$error_msg = "エラー　ルーム番号が0です。";
			//$this->redirect(array('controller' => 'staff', 'action' => 'top_menu', $this->_store_id,$this->_room_no,$error_msg));
		}
		$this->set('_room_no', $this->_room_no);

		//if(isset($this->data['order_no']))
		//	$this->_order_no = $this->data['order_no'];
		//$this->set('_order_no', $this->_order_no);

		if(isset($this->data['staff_id']))
			$this->_staff_id = $this->data['staff_id'];
		$this->set('_staff_id', $this->_staff_id);

		if(isset($this->data['staff_name']))
			$this->_staff_name = $this->data['staff_name'];
		$this->set('_staff_name', $this->_staff_name);

		if(isset($this->data['kind']))
			$this->_kind = $this->data['kind'];
		$this->set('_kind', $this->_kind);

		if(isset($this->data['error_msg']))
			$this->_error_msg = $this->data['error_msg'];
		$this->set('_error_msg', $this->_error_msg);

	}
	
	private function MakeHidden(){
		$hidden  = "<input type=\"hidden\" name=\"store_id\" value=\"".$this->_store_id."\">\r\n";
		$hidden  .= "<input type=\"hidden\" name=\"store_name\" value=\"".$this->_store_name."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"room_no\"  value=\"".$this->_room_no."\">\r\n";
		//$hidden .= "<input type=\"hidden\" name=\"order_no\"  value=\"".$this->_order_no."\">\r\n";
		
		$hidden .= "<input type=\"hidden\" name=\"staff_id\" value=\"".$this->_staff_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"staff_name\" value=\"".$this->_staff_name."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"kind\" value=\"".$this->_kind."\">\r\n";
//debug($hidden);		
		$this->set('hidden', $hidden);
		$this->CheckStaffCall();
	}


	private function CheckStaffCall(){
		$conditions = array('staff_call' => 2);
		$data = $this->CheckDT1->find('all', array('conditions' => $conditions));
		$this->set('staff_call', $data);
		if(count($data) > 0){
			$this->_staff_call_flag = 2;
		}
		$this->set('staff_call_flag', $this->_staff_call_flag);
		return $data;
	}

	private function DecodeCheckID(){
		$s = hexdec($this->_check_id);
//debug($s);
		$st = substr($s, 0, strlen($s)-2);
		$dt = date("Y-m-d H:i:s", (int)$st);
//debug($dt);
		$r = (int)substr($s, strlen($s)-2, 2);
//debug($r);
		return "(".$dt." ".$r.")";
	
	}


	private function WriteORD($cmd="0", $cart, $s_order_no=0){
//debug($cart);
//exit();
		if(isset($cart[0]['CartORD']['check_id'])){
			$this->_check_id = $cart[0]['CartORD']['check_id'];
			$this->_room_no = $cart[0]['CartORD']['room_no'];
		}else{
			$this->SetPublicConst();
		}
//debug($cart[$i]['CartORD']);
//debug($cart[$i]['CartORD']['order_no']);

		$dir_name = "RM".sprintf('%03d', $this->_room_no);
		$file_name = $dir_name.".ORD";
		$file_nameDT7 = $dir_name.".DT7";

		$path = $this->Common->GetRoomrdPath();
		$ord = "";
		if($cmd == "0"){
			if(file_exists($path.$file_nameDT7)){
				$this->read_DT7($path.$file_nameDT7);
				$this->delete_file($path.$file_nameDT7);
			}
//debug($cart);
			for($i=0; $i<count($cart); $i++){
				if($i <> 0)
					$ord .= "\r\n";
				$order_no = $cart[$i]['CartORD']['order_no'];
				$qty = $cart[$i]['CartORD']['qty'];
				$ord .= "0";
				$ord .= sprintf('%03d', $this->_room_no);
				$ord .= "00";
				$ord .= sprintf('%04d', $order_no);
				$ord .= "********";
				$ord .= "********";
				$ord .= sprintf('%02d', $qty);
				$ord .= "02300";
			}
//debug($ord);
		}elseif($cmd == "S"){
				$ord = "0";
				$ord .= sprintf('%03d', $this->_room_no);
				$ord .= "00";
				$ord .= sprintf('%04d', $s_order_no);
				$ord .= "********";
				$ord .= "********";
				$ord .= sprintf('%02d', 1);
				$ord .= "02300";
		}elseif($cmd == "U"){
				$ord = "0";
				$ord .= sprintf('%03d', $this->_room_no);
				$ord .= "00";
				$ord .= sprintf('%04d', 9974);	//注文問合せ
				$ord .= "********";
				$ord .= "********";
				$ord .= sprintf('%02d', 1);
				$ord .= "02300";
		}else{
			$ord = $cmd;
			$ord .= sprintf('%03d', $this->_room_no);
			$ord .= "0";
//debug($ord);
		}
		if(!isset($path)){
			debug("エラー");
			return;
		}
		$existsDt1 = $this->check_DT1($path.$file_name);
		$file = new File($path.$file_name, true);
//debug($ord);
		if($existsDt1){
   			$file->write("\r\n".$ord, "a", true);
		}else{
		   	$file->write($ord, "w", true);
		}
		$file->close();
		
		if($cmd == "T"){
			$this->RoomInfo->set('id', $this->_room_no);
			$this->RoomInfo->saveField('status', 0);		//1 入室、2タイムオーバー、3退室、4清掃中、0清掃終了
		}
	}


	private function check_DT1($path_file_name){
		if(file_exists($path_file_name)){
			$file = new File($path_file_name);
    		$contents = $file->read();
			if($contents)
				return true;
		}
		return false;
	}



//	http://s10.pierson.shop/psp/staff/checkins/
	public function checkins(){
	
	
		$this->set('staff_call_flag', $this->_staff_call_flag);
	}
















/*
	private function MoveOldData(){
		$conditions = array('check_id' => $this->_check_id);
		$data = $this->CheckDT1->find('first', array('conditions' => $conditions));
		if($data==array()){
			debug($this->_check_id." のCheckID データがない");
			exit();
		}
//debug($data);
//debug($this->_check_id);
		$id = $data['CheckDT1']['id'];
		$data['CheckDT1']['id'] = NULL;
		$save_array = $data['CheckDT1'];
//debug($save_array);
//debug($id);
		$this->OldCheckDT1->save($save_array);
		$this->CheckDT1->delete($id);
		
		
		$conditions = array('check_id' => $this->_check_id);
		$data = $this->CartDT7->find('all', array('conditions' => $conditions));
		if($data==array()){
			debug($this->_check_id." のCheckID データがない");
			exit();
		}
		for($i=0; $i<count($data); $i++){
			$id = $data[$i]['CartDT7']['id'];
			$data[$i]['CartDT7']['id'] = NULL;
			$save_array = $data[$i]['CartDT7'];
//debug($save_array);
//debug($id);
			$this->OldCartDT7->save($save_array);
			$this->CartDT7->delete($id);
		}
		$this->reset_check_cart_id();
	}
*/










/*
	public function checkout(){
		$this->SetPublicData();
		$this->GetStore();
//debug($this->data);

		if(isset($this->data['room_no1']) and isset($this->data['room_no2'])){
			$room_no = (int)$this->data['room_no1'] * 10 + (int)$this->data['room_no2'];
			
			if($room_no > 0){
				$this->_room_no = $room_no;
			}
		}else{
			$room_no=0;
		}
		if($room_no > 0){
			$cart = $this->GetCartData("order_history3");
			if($cart != array()){
				$this->set('cart', $cart);
//debug($cart);
				$conditions = array('check_id'=>$cart[0]['CartDT7']['check_id']);
				$check = $this->CheckDT1->find('first', array('conditions'=>$conditions));
				if($check != array()){
					$this->set('check', $check['CheckDT1']);
//debug($check);
					$data['checkin_time'] = $check['CheckDT1']['checkin_time'];
					$n = sprintf('%02d', $check['CheckDT1']['people']);
					$data['people1']=(int)substr($n, 0, 1);
					$data['people2']=(int)substr($n, 1, 1);

					$n = sprintf('%02d', $check['CheckDT1']['child']);
					$data['child1']=(int)substr($n, 0, 1);
					$data['child2']=(int)substr($n, 1, 1);

					$h = date("H");
					$m = date("i");
					$data['checkout_time1']=(int)substr($h, 0, 1);
					$data['checkout_time2']=(int)substr($h, 1, 1);
					$data['checkout_time3']=(int)substr($m, 0, 1);
					$data['checkout_time4']=(int)substr($m, 1, 1);
//debug($data);
					$data['course']=$check['CheckDT1']['course'];
					$data['drink_free']=$check['CheckDT1']['drink_free'];
					$data['discount']=$check['CheckDT1']['discount'];
			
					$data['check_id'] = $check['CheckDT1']['check_id'];
				}else{
					$data = array();
				}
			}else{
				$data = array();
			}
			$this->set('data', $data);
		}
		$this->set('room_no', $room_no);
		$this->MakeHidden();
	}

	public function print_checkout(){
		$this->SetPublicData();
		$this->GetStore();
//debug($this->data);
		$save_array = array();
//debug($this->request->data);
		if($this->request->data){
			$post = $this->request->data;
			$this->_store_id = $post['store_id'];
			if($post['kind']=="chekout2"){
				$kind = $post['kind'];
				$store_id = $post['store_id'];
				$checkin_time = $post['checkin_time'];
//debug($checkin_time);

				if($post['checkout_time1'] == 3){
					$checkout_time = NULL;
				}else{
					$checkout_hour = (int)$post['checkout_time1'] * 10 + (int)$post['checkout_time2'];
					$checkout_minute = (int)$post['checkout_time3'] * 10 + (int)$post['checkout_time4'];
					$checkout_time = date("Y-m-d ").$checkout_hour.":".$checkout_minute.":00";
				}
//debug($checkout_time);
				$time1 = new DateTime($checkin_time);
				$time2 = new DateTime($checkout_time);
				if($time2 < $time1)
					$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				$room_no = $post['room_no'];
				
				$people = (int)$post['people1'] * 10 + (int)$post['people2'];
				$child = (int)$post['child1'] * 10 + (int)$post['child2'];
				
				if(isset($post['drink_free']))
					$drink_free = $post['drink_free'];
				else
					$drink_free = 0;

				if(isset($post['discount']))
					$discount = $post['discount'];
				else
					$discount = 0;

				$course = $post['course'];
				if($course > 0){
					$checkout_time = date("Y-m-d H:i:s", strtotime("+".$course." hour", strtotime($checkin_time)));
					$time1 = new DateTime($checkin_time);
					$time2 = new DateTime($checkout_time);
					if($time2 < $time1)
						$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				}
				$this->_check_id = $post['check_id'];
				$this->set('check_id', $this->_check_id);

				$data = array('checkout_time'=>$checkout_time, 'people'=>$people, 'child'=>$child, 
					'drink_free'=>$drink_free, 'course'=>$course, 'discount'=>$discount);
				$conditions = array('check_id'=>$this->_check_id);
				$this->CartDT7->updateAll($data, $conditions);

				$data = array('checkout_time' => $checkout_time);
				$conditions = array('check_id'=>$this->_check_id);
				$this->CartDT7->updateAll($data, $conditions);
				
				$conditions = array('check_id'=>$this->_check_id);
				$check = $this->CheckDT1->find('first', array('conditions'=>$conditions));

//debug($this->_check_id);
				$save_array['id'] = $check['CheckDT1']['id'];			
				$save_array['check_id'] = $this->_check_id;		//$this->CheckDT1->getLastInsertID();

				$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id, 
						'order_send '=>2, 'deliver_send'=>2);
				$cart = $this->CartDT7->find('all', array('conditions' => $conditions));

				$this->set('cart', $cart);

				$this->MoveOldData();
			}
		}
//debug($save_array);				
		$this->set('data', $save_array);

		$this->MakeHidden();
	}
*/



/*
	function print_qr_code(){
		$this->SetPublicData();
		$save_array = array();
//debug($this->request->data);
		if($this->request->data){
			$post = $this->request->data;
			$this->_store_id = $post['store_id'];
			if($post['kind']=="chekin"){
				$kind = $post['kind'];
				$store_id = $post['store_id'];

				$checkin_hour = (int)$post['checkin_time1'] * 10 + (int)$post['checkin_time2'];
				$checkin_minute = (int)$post['checkin_time3'] * 10 + (int)$post['checkin_time4'];
				$checkin_time = date("Y-m-d ").$checkin_hour.":".$checkin_minute.":00";
//debug($checkin_time);
				if($post['checkout_time1'] == 3){
					$checkout_time = NULL;
				}else{
					$checkout_hour = (int)$post['checkout_time1'] * 10 + (int)$post['checkout_time2'];
					$checkout_minute = (int)$post['checkout_time3'] * 10 + (int)$post['checkout_time4'];
					$checkout_time = date("Y-m-d ").$checkout_hour.":".$checkout_minute.":00";
				}
//debug($checkout_time);
				$time1 = new DateTime($checkin_time);
				$time2 = new DateTime($checkout_time);
				if($time2 < $time1)
					$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				
				$room_no = (int)$post['room_no1'] * 10 + (int)$post['room_no2'];
				
				$people = (int)$post['people1'] * 10 + (int)$post['people2'];
				$child = (int)$post['child1'] * 10 + (int)$post['child2'];
				
				if(isset($post['drink_free']))
					$drink_free = $post['drink_free'];
				else
					$drink_free = 0;

				if(isset($post['discount']))
					$discount = $post['discount'];
				else
					$discount = 0;

				$course = $post['course'];
				if($course > 0){
					$checkout_time = date("Y-m-d H:i:s", strtotime("+".$course." hour", strtotime($checkin_time)));
					$time1 = new DateTime($checkin_time);
					$time2 = new DateTime($checkout_time);
					if($time2 < $time1)
						$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				}
				
				$check_id = dechex(strtotime('now').sprintf('%02d', $room_no));
//debug($check_id);
				$this->_store_id = $store_id;
				$this->_room_no = $room_no;
				$this->_check_id = $check_id;

				$save_array = array('id'=>NULL, 'check_id'=>$check_id, 'store_id'=>$store_id, 'checkin_time'=>$checkin_time, 
						'checkout_time0'=>$checkout_time, 'room_no'=>$room_no, 'people'=>$people, 
						'child'=>$child, 'drink_free'=>$drink_free, 'course'=>$course, 'discount'=>$discount,
						'staff_id'=>$post['staff_id'], 'staff_name'=>$post['staff_name'] );

				$this->CheckDT1->save($save_array);

				$conditions = array('check_id'=>$check_id);
				$check = $this->CheckDT1->find('first', array('conditions'=>$conditions));
				
				$check['CheckDT1']['decode_check_id'] = $this->Common->DecodeCheckID($this->_check_id);
				$url = "https://s.pierson.shop".$this->_dir."order/order_login/".$this->_store_id."/".$this->_room_no."/".$this->_check_id;			
				$check['CheckDT1']['url'] = $url;
			}
		}
//debug($save_array);				
		$this->set('data', $check['CheckDT1']);
		
		$this->GetStore();
		$this->MakeHidden();
	}
*/


	private function db_cleaning(){
		//'CheckDT1', 'CartDT7', 'CartORD'
		$ret = $this->CheckDT1->deleteAll(array('OR'=> array('up_date <=' => date("Y-m-d H:i:s", strtotime("-2 hour")),
						'check_id'=>NULL)));
		$ret = $this->CartDT7->deleteAll(array('up_date <' => date("Y-m-d H:i:s", strtotime("-1 day"))));
		$ret = $this->CartORD->deleteAll(array('order_time <' => date("Y-m-d H:i:s", strtotime("-1 day"))));
		
		//$ret = $this->CheckDT1->updateAll(array('check_id'=>NULL, 'dt4_flag'=>0, 'staff_call_time'=>0), array('room_no'=>$room_no));
		$ret = $this->CheckDT1->updateAll(array('check_id'=>NULL, 'dt4_flag'=>0, 'staff_call_time'=>0));
		$ret = $this->RoomInfo->updateAll(array('status'=>0));

		$this->Common->ResetModelID('CheckDT1');
		$this->Common->ResetModelID('CartDT7');
		$this->Common->ResetModelID('CartORD');

//debug($room_no);
//exit();
	}

}
